; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;-| AI |-------------------------------------------------------------
[Command]
name = "CPU1"
command = U,U,U,U,F,F,F,F
time = 1

[Command]
name = "CPU2"
command = U,D,DB,U,F,F,F,F,D
time = 1

[Command]
name = "CPU3"
command = U,D,F,U,F,F,F,F,U,D,U
time = 1

[Command]
name = "CPU4"
command = U,D,F,U,F,F,F,F,U,D,B
time = 1

[Command]
name = "CPU5"
command = B,D,F,U,F,F,F,F,U,D,U
time = 1

[Command]
name = "CPU6"
command = U,D,F,U,B,F,B,F,U,D,U
time = 1

[Command]
name = "CPU7"
command = F,B,F,U,B,F,B,F,U,D,U
time = 1


[Command]
name = "CPU8"
command = F,B,F,U,B,F,B,F,U,D,U,B
time = 1

[Command]
name = "CPU9"
command = F,B,F,U,B,F,B,F,U,D,U,B,F
time = 1

[Command]
name = "CPU10"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D
time = 1

[Command]
name = "CPU11"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,F
time = 1

[Command]
name = "CPU12"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B
time = 1

[Command]
name = "CPU13"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,F,DB
time = 1

[Command]
name = "CPU14"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU15"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF
time = 1

[Command]
name = "CPU16"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F
time = 1


[Command]
name = "CPU17"
command = F,B,F,U,B,F,B,F,U,D,U,B,F,D,B,DF,F
time = 1
;--------------------------------------------------------------------


[Command]
name = "corteplant"
command = F,D, F, x
time = 25


[Command]
name = "corteplant1"
command = F,D, F, y
time = 25

[Command]
name = "cortear"
command = D, B, y
time = 25

[Command]
name = "cortear1"
command = D, B, x
time = 25


[Command]
name = "faco"
command = F,D,F, a
time = 25

[Command]
name = "faco1"
command = F,D,F, b
time = 25

[Command]
name = "acido"
command = x+a
time = 25


[Command]
name = "rosewhip"
command = D,B, x
time = 25

[Command]
name = "rosewhip2"
command = D,B, y
time = 25


[Command]
name = "rosa"
command = D,F,x;~20$B, $F, x
time = 15

[Command]
name = "rosa2"
command = D,F,y;~20$B, $F, y
time = 15

[Command]
name = "asa"
command = D,F, x
time = 15

[Command]
name = "asa2"
command = D,F, y
time = 15

[Command]
name = "plantpower"
command =  D, DF, F, D, DF, F, y+b
time = 30

[Command]
name = "asaespecial"
command = D,F,D,F, y
time = 30

[Command]
name = "shoukan"
command = D,B,D,B,y
time = 30

[command]
name = "Plantarasteira"
command = D,B,D,B,x
time = 30


[Command]
name = "hold_x";Required (do not remove)
command = /x
time = 1

[Command]
name = "hold_y";Required (do not remove)
command = /y
time = 1

[Command]
name = "charge"
command = /y

[Command]
name = "charge 1"
command = /b

[Command]
name = "Superpulo"
command = ~D, U
time = 5

[Command]
name = "Superpulo"
command = ~D, UF
time = 5

[Command]
name = "Superpulo"
command = ~D, UB
time = 50

[Command]
name = "combo_aga"
command = x+a
time = 25

[Command]
name = "SocoChao"
command = y+b
time = 25

[Command]
name = "Empurra"
command = y+b
time = 20


[Command]
name = "hold_s"
command = /z
time = 1






;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]


;=========================================================================


[state -1]
type = changestate
triggerall = random < 100
triggerall = var(59) = 1
triggerall = stateno != 40
triggerall = statetype != a
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numhelper >= 1)
trigger1 = ctrl = 1
trigger2 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger2 = ctrl = 1
value = 40

[state -1]
type = varset
trigger1 = var(59) = 1
trigger1 = (p2movetype = a) && (p2statetype != a) && (enemy, numproj >= 1)
trigger1 = ctrl = 1
v = 3
value = 1

[State -1, Inteligencia]
type = VarSet
trigger1  = command = "CPU1"
trigger2  = command = "CPU2"
trigger3  = command = "CPU3"
trigger4  = command = "CPU4"
trigger5  = command = "CPU5"
trigger6  = command = "CPU6"
trigger7  = command = "CPU7"
trigger8  = command = "CPU8"
trigger9  = command = "CPU9"
trigger10  = command = "CPU10"
trigger11  = command = "CPU11"
trigger12  = command = "CPU12"
trigger13  = command = "CPU13"
trigger14  = command = "CPU14"
trigger15  = command = "CPU15"
trigger16  = command = "CPU16"
trigger17  = command = "CPU17"
v = 59
value = 1

[state -1]
type = changestate
value = 0
triggerall = var(59) = 1
triggerall = roundstate = 3
trigger1 = statetype != a
trigger1 = ctrl

;------------------COMBOS YUSUKE--------------------------------------------
;ground combo 0--------------------------------------------------
[state -1,1]
type = changestate
value = 200
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 50

[state -1]
type = changestate
value = 201
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 200
trigger1 = movecontact


[state -1]
type = changestate
value = 202
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 201
trigger1 = movecontact


[state -1]
type = changestate
value = 360
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 202
trigger1 = movecontact

[state -1]
type = changestate
value = 230
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 200
trigger1 = movecontact

[state -1]
type = changestate
value = 231
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 230
trigger1 = movecontact

[state -1]
type = changestate
value = 232
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 231
trigger1 = movecontact


[state -1]
type = changestate
value = 231
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 230
trigger1 = movecontact

[state -1]
type = changestate
value = 232
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 231
trigger1 = movecontact

[state -1]
type = changestate
value = 240
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 232
trigger1 = movecontact

[state -1]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 201 || stateno = 230 
trigger1 = movecontact

[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 210  || stateno = 230 || stateno = 400 || stateno = 430 = stateno = 240
trigger1 = movecontact


;ground combo 1--------------------------------------------------
[state -1,1]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,30]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50


[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 210
trigger1 = movecontact



;ground combo 2--------------------------------------------------
[state -1,1]
type = changestate
value = 400
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,20]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,20]
trigger2 = random < 50

[state -1]
type = changestate
value = 430
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 400
trigger1 = movecontact


[state -1]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 430
trigger1 = movecontact


;ground combo 3--------------------------------------------------
[state -1,1]
type = changestate
value = 210
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = ctrl = 1
trigger1 = p2bodydist x = [0,30]
trigger1 = random < 50
trigger2 = stateno = 100
trigger2 = p2bodydist x = [0,30]
trigger2 = random < 50


[state -1]
type = changestate
value = 240
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 210
trigger1 = movecontact

[state -1]
type = changestate
value = 212
triggerall = var(59) = 1 && roundstate =2
trigger1 = stateno = 211
trigger1 = movecontact




;ground combo 4--------------------------------------------------
[state -1,2]
type = changestate
value = 410
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
trigger1 = stateno = 210
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 60
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
;triggerall = power >= 500
;triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 410
trigger1 = movecontact
trigger1 = p2bodydist x < 20
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 100 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 20
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 600
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 60
trigger1 = movecontact
trigger1 = p2bodydist x < 40
trigger2 = p2bodydist x = [0,50]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 630
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 600
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 610
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 630
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 640
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 610
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 500 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 640
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 611
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != S
trigger1 = stateno = 610
trigger1 = movecontact
trigger1 = p2bodydist x < 30
trigger2 = p2bodydist x = [0,40]
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl


;----------------------Golpes AI--------------------------------

[state -1,2]
type = changestate
value = 700
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 100
triggerall = time >10
;trigger1 = (Movehit)
trigger1 =  stateno = 200 ||  stateno = 210 ||  stateno = 212 ||  stateno = 230 ||  stateno = 240||  stateno = 410
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 700
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 100
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 200 ||  stateno = 210 ||  stateno = 212 ||  stateno = 230 ||  stateno = 240
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 701
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >15
;trigger1 = (Movehit)
trigger1 =  stateno = 200 ||  stateno = 210 ||  stateno = 212 ||  stateno = 230 ||  stateno = 240||  stateno = 410 ||  stateno = 430        
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 701
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 200 ||  stateno = 210 ||  stateno = 212 ||  stateno = 230 ||  stateno = 240 || stateno = 430 
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 702
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >3
;trigger1 = (Movehit)
trigger1 =  stateno = 210|| stateno = 212 || stateno = 230 || stateno = 240  || stateno = 232 
trigger1 = movecontact
trigger2 = p2bodydist x = [0,30]
trigger2 = random < 20 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 702
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 200
triggerall = time >3
trigger1 = (Movehit)
trigger1 =  stateno = 210|| stateno = 212 || stateno = 230 || stateno = 240  || stateno = 232 
trigger1 = movecontact
trigger2 = p2bodydist x = [0,30]
trigger2 = random < 20 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 704
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
;trigger1 = (Movehit)
trigger1 =  stateno = 212 ||  stateno = 240 || stateno = 230 || stateno = 232
trigger1 = movecontact
trigger2 = p2bodydist x = [0,30]
trigger2 = random < 20 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 704
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >5
trigger1 = (Movehit)
trigger1 =  stateno = 212 || stateno = 240 || stateno = 230 || stateno = 232
trigger1 = movecontact
trigger2 = p2bodydist x = [0,30]
trigger2 = random < 20 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 706
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 450
triggerall = time >15
;trigger1 = (Movehit)
trigger1 =  stateno = 212 ||  stateno = 240 ||  stateno = 700 ||  stateno = 410  
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 706
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 450
triggerall = time >15
trigger1 = (Movehit)
trigger1 =  stateno = 212 ||  stateno = 240 ||  stateno = 700  ||  stateno = 702
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 707
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 200 || stateno = 210|| stateno = 212 || stateno = 230 || stateno = 240 || stateno = 400 || stateno = 430
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 707
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 200 || stateno = 210|| stateno = 212 || stateno = 230 || stateno = 240 || stateno = 400 || stateno = 430
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 708
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 300
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 200 || stateno = 210|| stateno = 212 || stateno = 230 || stateno = 240 || stateno = 400 || stateno = 430
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 708
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 300
triggerall = time >5
;trigger1 = (Movehit)
trigger1 = stateno = 200 || stateno = 210|| stateno = 212 || stateno = 230 || stateno = 240 || stateno = 400 || stateno = 430
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl


[state -1,2]
type = changestate
value = 709
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 150
triggerall = time >10
;trigger1 = (Movehit)
trigger1 =  stateno = 702 ||  stateno = 704 ||  stateno = 700 ||  stateno = 702  ||  stateno = 410 
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 710
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >5
trigger1 = (Movehit)
trigger1 =  stateno = 212 ||  stateno = 240 ||  stateno = 700 
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 712
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 611 
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 714
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 200
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 611 || stateno = 610 || stateno = 640
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 714
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 200
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 611 || stateno = 610 || stateno = 640
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 715
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 250
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 610 || stateno = 640
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 720
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 150
triggerall = time >5
trigger1 = (Movehit)
trigger1 = stateno = 610 || stateno = 640
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 716
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 250
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 700 || stateno = 212 || stateno = 240 
trigger1 = movecontact
trigger2 = random < 50 && enemynear, statetype = l
trigger2 = ctrl

[state -1,2]
type = changestate
value = 720
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 150
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 611 || stateno = 640
trigger1 = movecontact
trigger2 = random < 60 && enemynear, statetype = l
trigger2 = ctrl

;----------------------ESPECIAIS AI--------------------------------------

[state -1]
type = changestate
value = 705
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
Triggerall = numhelper(1350) = 0
triggerall = power >= 1000
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno = 212 || stateno = 240|| stateno = 700 || stateno = 702 || stateno = 709 || stateno = 710
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 705
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
Triggerall = numhelper(1350) = 0
triggerall = power >= 1000
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno = 212 || stateno = 240|| stateno = 700 || stateno = 702 
trigger1 = movecontact
trigger1 = random < 20

[state -1]
type = changestate
value = 1400
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 1500
triggerall = time >20
trigger1 = (Movehit)
trigger1 = stateno =  stateno = 611 || stateno = 702  || stateno = 704 || stateno = 711  || stateno = 712
trigger1 = movecontact
trigger1 = random < 20


[state -1]
type = changestate
value = 1400
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != s
triggerall = power >= 1500
triggerall = time >20
;trigger1 = (Movehit)
trigger1 = stateno =  stateno = 611 || stateno = 702  || stateno = 704 || stateno = 711  || stateno = 712
trigger1 = movecontact
trigger1 = random < 20



[state -1]
type = changestate
value = 1050
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 2000
triggerall = time >10
trigger1 = (Movehit)
trigger1 = stateno =  stateno = 707 || stateno = 705
trigger1 = movecontact
trigger1 = random < 20


[state -1]
type = changestate
value = 1050
triggerall = var(59) = 1 && roundstate =2
triggerall = statetype != a
triggerall = power >= 2000
triggerall = time >10
;trigger1 = (Movehit)
trigger1 = stateno =  stateno = 707 ;|| stateno = 708 
trigger1 = movecontact
trigger1 = random < 20

;-------------------------------Ai especiais--------------------------------------

[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 1000
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 180
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<100,705,705) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<150,705,705)
value = ifelse (p2bodydist x<180,705,705) ;escolhe o golpe a ser executado


[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 2000
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 230
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<160,1050,1050) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<190,1050,1050)
value = ifelse (p2bodydist x<230,1050,1050) ;escolhe o golpe a ser executado


[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = A && movetype != H
triggerall = power >= 1500
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 230
trigger1 = p2statetype != S
value = ifelse (p2bodydist x<120,1400,1400) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<220,1400,1400)
value = ifelse (p2bodydist x<320,1400,1400) ;escolhe


[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 2500
trigger1 = ctrl
trigger1 = random <= 10 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 230
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<330,3400,3400) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<430,3400,3400)
;value = ifelse (p2bodydist x<320,1400,1400) 



;-------------------------------Ai Golpes--------------------------------------

[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 100
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 183
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<103,709,709) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<153,709,709)
value = ifelse (p2bodydist x<183,709,709) ;escolhe o golpe a ser executado

[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 200
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 185
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<105,710,710) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<155,710,710)
value = ifelse (p2bodydist x<185,710,710) ;escolhe o golpe a ser executado

[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 150
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 75
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<50,707,707) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<65,707,707)
value = ifelse (p2bodydist x<75,707,707) ;escolhe o golpe a ser executado

[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 300
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 86
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<66,708,708) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<76,708,708)
value = ifelse (p2bodydist x<86,708,708) ;escolhe o golpe a ser executado


[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 200
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 43
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<33,702,702) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<43,702,702)
;value = ifelse (p2bodydist x<75,707,707) ;escolhe o golpe a ser executado

[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 250
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 63
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<53,704,704) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<63,704,704)
;value = ifelse (p2bodydist x<86,708,708) 

[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 100
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 30
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<20,700,700) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<30,700,700)
;value = ifelse (p2bodydist x<75,707,707) ;escolhe o golpe a ser executado

[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 200
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 125
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<115,701,701) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<125,701,701)


[State -1, Inteligencia]
type = ChangeState
triggerall = roundstate = 2
triggerall = var(59) != 0
triggerall = statetype = S && movetype != H
triggerall = power >= 300
trigger1 = ctrl
trigger1 = random <= 20 ; quanto maior mais vezes executar golpe
trigger1 = p2bodydist x < 90
trigger1 = p2statetype != A
value = ifelse (p2bodydist x<80,706,706) ;escolhe o golpe a ser executado
value = ifelse (p2bodydist x<90,706,706)

;===========================================================================

;Super  especial

[State -1, ]
type = ChangeState
triggerall = var(2) = 0
Triggerall = numhelper(1350) = 0
Triggerall = power >= 1000
value = 705
triggerall = command = "Plantarasteira"
trigger1 = statetype != A
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 1050
triggerall = command = "shoukan"
triggerall = power >=2000
trigger1 = statetype = S
trigger1 = ctrl

[State -1,Rose01 ]
type = ChangeState
value = 1400
triggerall = command = "asaespecial"
trigger1 = statetype = A
triggerall = power >= 1500
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 3400
triggerall = command = "plantpower"
triggerall = power >=2500
trigger1 = statetype = S
trigger1 = ctrl


;-------------------------GOLPES NORMAIS-----------------------------------


[State -1, ]
type = ChangeState
value = 700
triggerall = command = "corteplant"
triggerall = power >=100
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 701
triggerall = command = "corteplant1"
triggerall = power >=200
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 702
triggerall = command = "faco"
triggerall = power >=200
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 704
triggerall = command = "faco1"
triggerall = power >=250
trigger1 = statetype = S
trigger1 = ctrl



[State -1, ]
type = ChangeState
value = 706
triggerall = command = "acido"
triggerall = power >=300
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 707
triggerall = command = "rosewhip"
triggerall = power >=150
trigger1 = statetype = S
trigger1 = ctrl



[State -1, ]
type = ChangeState
value = 708
triggerall = command = "rosewhip2"
triggerall = power >=300
trigger1 = statetype = S
trigger1 = ctrl


[State -1, ]
type = ChangeState
value = 709
triggerall = command = "rosa"
triggerall = power >=100
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 710
triggerall = command = "rosa2"
triggerall = power >=250
trigger1 = statetype = S
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 711
triggerall = command = "asa"
triggerall = power >=150
trigger1 = statetype = A
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 712
triggerall = command = "asa2"
triggerall = power >=200
trigger1 = statetype = A
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 714
triggerall = command = "acido"
triggerall = power >=300
trigger1 = statetype = A
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 715
triggerall = command = "cortear"
triggerall = power >=100
trigger1 = statetype = A
trigger1 = ctrl

[State -1, ]
type = ChangeState
value = 720
triggerall = command = "cortear1"
triggerall = power >=150
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl


[State -1, correndo frente ar]
type = ChangeState
value = 102
trigger1 = command = "FF"
trigger1 = statetype = A
trigger1 = ctrl

[State -1, correndo traz ar]
type = ChangeState
value = 115
trigger1 = command = "BB"
trigger1 = statetype = A
trigger1 = ctrl

;---------------------------------------------------------------------------

[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

[State -1:Super pulo]
type = ChangeState
value = 60
triggerall = !var(59)&&command = "Superpulo"
trigger1 = (statetype = S) && (ctrl)

; Carregar Energia 01
[State -1, powercharge]
type=changestate
value=500
trigger1= var(59)<=0
trigger1= command="hold_s"; && command="holdy"
trigger1= roundstate=2 && statetype!=A && ctrl
trigger1= power<const(data.power) && power<powermax && !var(20)


[State -1, Guard Push stand]
type = ChangeState
value = 160
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = S
trigger1 = stateno = [150,153]

[State -1, Guard Push crouch]
type = ChangeState
value = 161
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = C
trigger1 = stateno = [150,153]

[State -1, Guard Push aerial]
type = ChangeState
value = 162
triggerall = power >= 150
triggerall = command = "Empurra" && statetype = A
trigger1 = stateno = [154,155]




;----------------------------combos m------------------------------------

[State -1]
type = ChangeState
value = 230
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S


;---------------------------------------------------------------------------
;Stand Light Punch
;p`
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
;triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 10

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 201
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 360
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 202
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 210
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 200
triggerall = movecontact = 1
trigger1 = statetype = S



[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 211 || stateno = 202
triggerall = movecontact = 1
trigger1 = statetype = S



;[State -1]
;type = ChangeState
;value = 800
;triggerall = Var(1) = 0
;triggerall = alive = 1
;triggerall = command = "combo_aga"
;triggerall = stateno = 211
;triggerall = movecontact = 1
;trigger1 = statetype = S

;------------------------------------------------------------------------------

[State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 201
triggerall = movecontact = 1
trigger1 = statetype = S


;---------------------------------------------------------------------------
;Stand Strong Punch
;p`
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 211) && time > 50
trigger3 = (stateno = 210) && time > 60

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 410
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = command = "holddown"
triggerall = stateno = 212
triggerall = movecontact = 1
trigger1 = statetype = S


[State -1]
type = ChangeState
value = 212
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S
trigger2 = (stateno = 212) && time > 5
trigger3 = (stateno = 211) && time > 6


[State -1]
type = ChangeState
value = 202
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 210
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Stand Light Kick
;LbN
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 7
trigger3 = (stateno = 230) && time > 9

[State -1]
type = ChangeState
value = 231
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 232
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 231
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 240
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 232
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 800
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "combo_aga"
triggerall = stateno = 232
triggerall = movecontact = 1
trigger1 = statetype = S

[State -1]
type = ChangeState
value = 200
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "x"
triggerall = stateno = 230
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Standing Strong Kick
;LbN
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6


[State -1]
type = ChangeState
value = 800
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "combo_aga"
triggerall = stateno = 240
triggerall = movecontact = 1
trigger1 = statetype = S

;---------------------------------------------------------------------------
;Taunt
;
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
;Ⴊݎp`
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Strong Punch
;Ⴊ݋p`
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)


[State -1]
type = ChangeState
value = 60
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "Superpulo"
triggerall = stateno = 410
triggerall = movecontact = 1
trigger1 = statetype = S
;---------------------------------------------------------------------------
;Crouching Light Kick
;ႪݎLbN
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Crouching Strong Kick
;Ⴊ݋LbN
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 9) || (movecontact && time > 5)

;---------------------------------------------------------------------------
;Jump Light Punch
;󒆎p`
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 15
;trigger3 = stateno = 1350 ;Air blocking

[State -1]
type = ChangeState
value = 630
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "a"
triggerall = stateno = 600
triggerall = movecontact = 1
trigger1 = statetype = A


;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

[State -1]
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 610
triggerall = movecontact = 1
trigger1 = statetype = A

[State -1]   ;chute ar forte original
type = ChangeState
value = 611
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "SocoChao"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 1350 ;Air blocking

[State -1]
type = ChangeState
value = 640
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "b"
triggerall = stateno = 630
triggerall = movecontact = 1
trigger1 = statetype = A


;---------------------------------------------------------------------------
;Jump Strong Kick
;󒆋LbN
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking


[State -1]
type = ChangeState
value = 610
triggerall = Var(1) = 0
triggerall = alive = 1
triggerall = command = "y"
triggerall = stateno = 640
triggerall = movecontact = 1
trigger1 = statetype = A



